<?php

/**
 *
 * INDEXU
 * Copyright(C), Nicecoder, 2000-2006, All Rights Reserved.
 *
 * INDEXU(tm) is protected by Indonesia and International copyright laws.
 * Unauthorized use or distribution of INDEXU(tm) is strictly prohibited,
 * violators will be prosecuted. To obtain a license for using INDEXU(tm),
 * please register at Nicecoder home page at http://www.nicecoder.com
 *
 * Author:
 *    Dody Rachmat Wicaksono (dody@nicecoder.com)
 *    M. Zuber (zubby@nicecoder.com)
 *
 */

  /*===================================================
    main
  ===================================================*/

  include "application.php";
  
  RemoveFilter("gzip_compression");
  RemoveFilter("runtime");
  RunPreFilter(__FILE__);

  $arr = array_rand(array('1', '2', '3', '4', '5', '6', '7', '8', '9'), 4);
  $key = $arr[0].$arr[1].$arr[2].$arr[3];

  // put in session
  $_SESSION['captcha_key'] = $key;

  // box color
  $image = imagecreatetruecolor(81, 31);
  $back = imagecolorallocate($image, intval(rand(224, 255)), intval(rand(224,255)), intval(rand(224, 255)));
  imagefilledrectangle($image, 0, 0, 81, 31, $back);

  // random grid color
  for ($i = 0; $i <= 80; $i+=10) {
    $color = imagecolorallocate($image, intval(rand(160, 224)), intval(rand(160, 224)), intval(rand(160, 224)));
    imageline($image, $i, 0, $i, 30, $color);
  }
  for ($i=0; $i <= 30; $i+=10) {
    $color = imagecolorallocate($image,intval(rand(160, 224)), intval(rand(160, 224)), intval(rand(160, 224)));
    imageline($image, 0, $i, 120, $i, $color);
  }

  // key to read
  for ($i = 0, $x = 12; $i < 4; $i++) {
    $r = intval(rand(0,128));
    $g = intval(rand(0,128));
    $b = intval(rand(0,128));
    $color = imagecolorallocate($image, $r,$g,$b);
    $shadow = imagecolorallocate($image, $r + 128, $g + 128, $b + 128);
    $size = intval(rand(12, 17));
    $text = substr($key, $i, 1);
    $y = intval(rand(6, 12));
    imagestring($image, 5, $x + 1, $y + 1, $text, $shadow);
    imagestring($image, 5, $x, $y, $text, $color);
    $x += $size + 2;
  }

  // display captcha image
  header("Content-type: image/png");
  imagepng($image);
  imagedestroy($image);

  RunPostFilter(__FILE__);

?>